;Ŀ
;This is the sprite routine I used in XC-1701. It draws a sprite which's base
;address is stored at DE at position (B,C)                                   
;Be sure to an one-byte variable named TempByte!                             
;                                                                            
;As XC-1701 is my first program for ZShell, this routine is not optimized.   
;If you find a way to do this faster, please write me a letter:              
; Andreas Ess                                                                
; Tufers 156                                                                 
; A-6811 Goefis                                                              
; Austria/Europe                                                             
;                                                                            
;Please give me an appropriate credit if you use this peace of code.         
; Thanx, Andreas                                                             
;

;-----------------------------------------------------------------------------
;Draws a sprite DE at position (B,C)
;-----------------------------------------------------------------------------
Bitmap:
 push hl                   ;save regs
 push de
 push bc
 ld   a, 0                 ;store 0 into TempByte
 ld   (TempByte), a
 ld   h, 0                 ;store y-position into hl and
 ld   l, c                 ;multiplicate it by 16
 add  hl, hl ;*2
 add  hl, hl ;*4
 add  hl, hl ;*8
 add  hl, hl ;*16
 push de                   ;save de & bc temporary
 push bc
 srl  b                    ;divide b by 8
 srl  b
 srl  b
 ld   d,  0                ;load edited x-position into de
 ld   e,  b                ;add it to y-position
 add  hl, de               ;and finally
 ld   de, $FC00            ;let it point to the vid-ram
 add  hl, de
 pop  bc                   ;pop de & bc
 pop  de
 ld   a, b                 ;load real x-position
 and  7                    ;into and make
 cp   0                    ;something like mod(a,7)
 ld   c, 128               ;c is the video-mask,
 ld   b, 128               ;b the bitmap-mask
 jr   z, Loop              ;if modulo = 0, jump directly to drawloop
 ld   b, a                 ;else shift right mod(a,7) times
Shift:
 srl  c
 djnz Shift
 ld   b, 128               ;b is 128 = bit 7 of bitmap
Loop:
 ld   a, (de)              ;load bitmap-data into a
 and  b                    ;test only one bit
 jr   z, Set0              ;if bit = zero; erase point
 ld   a, (hl)              ;otherwise, draw point
 or   c
 jr   Loop1
Set0:
 ld   a, c                 ;erase point
 xor  255
 and  (hl)
Loop1:
 ld   (hl), a              ;now save this into video-ram
 srl  c                    ;and shift the video-mask -> next pixel
 jr   nz, Loop2            ;if mask is zero -> fill 128 into c
 ld   c, 128               ;and use next byte of vid-data
 inc  hl
Loop2:
 srl  b                    ;now shift the bitmap-mask
 jr   nz, Loop             ;if <> zero, loop again
NextLine:
 push de                   ;save de
 ld   de, 15
 add  hl, de               ;add 15 bytes to hl
 pop  de
 inc  de                   ;and increment bitmap-pointer
 ld   b, 128               ;load 128 into bitmap-pointer
 ld   a, (TempByte)        ;TempByte holds line
 inc  a
 ld   (TempByte), a
 cp   8
 jr   nz, Loop             ;if line<8, loop again
EndBMP:
 pop  bc
 pop  de
 pop  hl
 ret
