FindStr    = $90A4 ;   6 BYTE
OldPAddr   = $90AA ;   1 WORD
Crs1	   = $90AC ;   1 WORD
Crs2	   = $90AE ;   1 WORD
curOpt	   = $90B0 ;   1 BYTE
IY0D	   = $90B1 ;   1 BYTE
curMenu    = $90B2 ;   1 BYTE
tmp	   = $90B3 ;   1 BYTE
TBLcurC    = $90B4 ;   1 WORD
nrHits	   = $90B6 ;   1 BYTE
searches   = $90B7 ;   1 BYTE
curMemL    = $90B8 ;   1 BYTE
searchval  = $90B9 ;   7 BYTE
pointers   = $90C0 ;  32 WORD
IntTable   = $9100 ; 257 BYTE
MemoryTbl  = $9201 ; 120 BYTE  (6 entries, 20 byte each)
GameDelay  = $9279 ;   1 BYTE

#INCLUDE ti-85.h

.org 0
.db "Game Wizard 0.9      ",0

 jr InitGWiz
 JUMP_(MenuHandler)
InitGWiz:
 CALL_(ShowFrame)
 ld hl,IntTable
 ld a,(hl)
 cp $92
 jr z,RemoveInterrupt
 ld (hl),$92
 ld b,0
RepFill:
 inc hl
 ld (hl),$92
 djnz RepFill
 ld hl,FindStrS
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,FindStr
 ld bc,6
 ldir
 ld hl,IntStartO
 ld de,(PROGRAM_ADDR)
 ld (OldPAddr),de
 add hl,de
 ld bc,IntEnd-IntStart+1
 ld de,$9292
 ldir
 ld hl,StatText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$0503
 ld ($800C),de
 ROM_CALL(D_ZT_STR)
 inc hl
 inc hl
 ld de,$0604
 ld ($800C),de
 ROM_CALL(D_ZT_STR)
 ld de,$3009
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 call ClearTable
 xor a
 ld (gamedelay),a
 ld (searches),a
 ld a,$91
 ld i,a
 im 2
WaitMess:
 call GET_KEY
 or a
 jr z,WaitMess
 ret

RemoveInterrupt:
 im 1
 ld (hl),0
 ld hl,StatText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$0503
 ld ($800C),de
 ROM_CALL(D_ZT_STR)
 ld de,$0504
 ld ($800C),de
 ROM_CALL(D_ZT_STR)
 jr WaitMess

SaveScreen:
 ld hl,LCD
 ld de,(PROGRAM_ADDR)
 add hl,de
 ex de,hl
 ld hl,$FC00
 ld bc,1024
 ldir
 ret

RestoreScreen:
 ld hl,LCD
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$FC00
 ld bc,1024
 push hl
 ldir
 pop hl
 ld (hl),0
 ld d,h
 ld e,l
 inc de
 ld bc,1023
 ldir
 ret

ShowHeader:
 ROM_CALL(CLEARLCD)
 ld hl,0
 ld ($800C),hl
 set 3,(iy+5)
 ld hl,(PROGRAM_ADDR)
 ROM_CALL(D_ZT_STR)
 res 3,(iy+5)
 ret

ShowFrame:
 CALL_(ShowHeader)
 ld hl,$3A02
 ld ($8333),hl
 ld hl,Coder
 ld de,(PROGRAM_ADDR)
 add hl,de
 ROM_CALL(D_ZM_STR)
 ld hl,$FFA0
 ld b,16
RepHLine:
 ld (hl),$FF
 inc hl
 djnz RepHLine
 ret

Show_Hex_Digit:
 add a,48
 cp 58
 jr c,ShowHexLet
 add a,7
ShowHexLet:
 push de
 ROM_CALL(M_CHARPUT)
 pop de
 ret

Disp_A_Hex:
 push af
 srl a
 srl a
 srl a
 srl a
 CALL_(Show_Hex_Digit)
 pop af
 and $0F
 CALL_(Show_Hex_Digit)
 ret

Disp_HL_Hex:
 ld a,h
 CALL_(Disp_A_Hex)
 ld a,l
 CALL_(Disp_A_Hex)
 ret

GetKey:
 ld hl,$8001
 CALL_(ReadKey)
 ld (hl),a
 ld a,($8000)
 cp (hl)
 jr nz,NewKey
 ld (hl),0
 jr EndReadKey
NewKey:
 ld a,(hl)
 ld ($8000),a
EndReadKey:
 ld a,(hl)
 or a
 ret

GetTBLOfs:
 ld hl,MemoryTbl
 ld a,(TBLCurC)
 ld d,0
 ld e,a
 inc e
 sla e
 sla e
 sla e
 sla e
 add a,a
 add a,a
 add a,e
 ld e,a
 add hl,de
 ret

FillDesc:
 push af
 push hl
 ld b,16
RepFillDesc:
 ld (hl),d
 inc hl
 djnz RepFillDesc
 ld a,d
 cp 32
 jr z,RepClrEntry
 pop hl
 pop af
 ret
RepClrEntry:
 ld a,32
 ROM_CALL(M_CHARPUT)
 ld a,($8333)
 cp $58
 jr c,RepClrEntry
 ld a,$0F
 ld ($8333),a
 pop hl
 pop af
 ret

GetDescPos:
 ld a,(TBLCurC)
 add a,a
 add a,a
 add a,a
 add a,$0C
 ld d,a
 ld e,$0F
 ld ($8333),de
 ret

TBLInsertMemL:
 CALL_(GetTBLOfs)
 CALL_(XorTBLOpt)
 ld a,1
 ld (TBLCurC+1),a
 CALL_(GetTBLOfs)
 push hl
 ld a,(curMemL)
 add a,a
 ld hl,pointers
 ld d,0
 ld e,a
 add hl,de
 call LD_HL_MHL
 JUMP_(TBLWriteChg)

TBLRemLet:
 CALL_(GetDescPos)
 CALL_(XorTBLOpt)
 CALL_(GetTBLOfs)
 push hl
 inc hl
 inc hl
 inc hl
 ld a,(hl)
 or a
 jr z,DescEmpty
 dec (hl)
 ld a,(hl)
 pop hl
 ld de,16
 or a
 sbc hl,de
 ld d,0
 ld e,a
 push hl
 add hl,de
 ld (hl),32
 or a
 ld d,45
 pop hl
 CALL_Z(FillDesc)
 ld b,16
 ROM_CALL(D_LM_STR)
 CALL_(XorTBLOpt)
 JUMP_(TBLMove)

DescEmpty:
 pop hl
 CALL_(XorTBLOpt)
 JUMP_(TBLMove)

TBLEnterDesc:
 CALL_(GetDescPos)
 CALL_(XorTBLOpt)
 CALL_(GetTBLOfs)
 push hl
 inc hl
 inc hl
 inc hl
 ld a,(hl)
 or a
 jr nz,NotEmpty
 push hl
 ld de,19
 or a
 sbc hl,de
 ld d,32
 CALL_(FillDesc)
 pop hl
NotEmpty:
 cp 15
 jr z,LastLet
 inc (hl)
LastLet:
 pop hl
 or a
 ld de,16
 sbc hl,de
 push hl
 ld d,0
 ld e,a
 add hl,de
 ld a,c
 cp 26
 jr nz,NotSpace
 ld a,32
 jr PutLetter
NotSpace:
 add a,65
 push hl
 ld hl,tmp
 bit 0,(hl)
 jr z,BigLet
 add a,32
BigLet:
 pop hl
PutLetter:
 ld (hl),a
 ld b,16
 pop hl
 ROM_CALL(D_LM_STR)
 CALL_(XorTBLOpt)
 JUMP_(TBLMove)

XorTBLOpt:
 push hl
 ld b,7
TBLXorNewRow:
 push bc
 ld a,(TBLcurC)
 ld h,a
 ld l,0
 rr h
 rr l
 ld de,$FCB0
 add hl,de
 ld d,0
 ld e,b
 sla e
 sla e
 sla e
 sla e
 add hl,de
 ld a,(TBLcurC+1)
 push hl
 ld hl,TBLcoord
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld d,0
 ld e,a
 sla e
 sla e
 add hl,de
 ex de,hl
 pop hl
 ld a,(de)
 ld b,0
 ld c,a
 add hl,bc
 inc de
 ld a,(de)
 inc de
 xor (hl)
 ld (hl),a
 inc hl
 ld a,(de)
 inc de
 or a
 jr z,NoBigXor
 ld b,a
TBLRepXor:
 ld a,$FF
 xor (hl)
 ld (hl),a
 inc hl
 djnz TBLRepXor
NoBigXor:
 ld a,(de)
 xor (hl)
 ld (hl),a
 pop bc
 djnz TBLXorNewRow
 pop hl
 ret

TableML:
 CALL_(ShowHeader)
 ld hl,MemoryTbl
 xor a
 ld (tmp),a
DispNextEntry:
 push af
 add a,a
 add a,a
 add a,a
 add a,$0C
 ld d,a
 ld e,$06
 ld ($8333),de
 pop af
 inc a
 push af
 add a,48
 ROM_CALL(M_CHARPUT)
 ld a,46
 ROM_CALL(M_CHARPUT)
 ld a,($8333)
 add a,3
 ld ($8333),a
 ld b,16
 ROM_CALL(D_LM_STR)
 ld a,$58
 ld ($8333),a
 push hl
 call LD_HL_MHL
 push hl
 CALL_(Disp_HL_Hex)
 pop hl
 ld a,$70
 ld ($8333),a
 ld a,(hl)
 CALL_(Disp_A_Hex)
 pop hl
 inc hl
 inc hl
 inc hl
 inc hl
 pop af
 cp 6
 jr nz,DispNextEntry
 ld hl,$0000
 ld (TBLcurC),hl
TBLMoveXor:
 CALL_(XorTBLOpt)
TBLMove:
 CALL_(GetKey)
 or a
 jr z,TBLMove
 cp K_EXIT
 JUMP_Z(ViewMenu)
 ld hl,TBLCurC
 cp K_SECOND
 JUMP_Z(TBLInsertMemL)
 cp K_ALPHA
 JUMP_Z(TBLLetChg)
 cp K_CLEAR
 jr z,TBLClear
 cp K_DOWN
 jr z,TBLMoveDown
 cp K_LEFT
 jr z,TBLMoveLeft
 cp K_RIGHT
 jr z,TBLMoveRight
 cp K_UP
 jr z,TBLMoveUp
 ld c,a
 ld a,(TBLCurC+1)
 or a
 ld de,(PROGRAM_ADDR)
 ld a,c
 jr z,TBLLeftCol
 ld hl,K_HexCodes
 add hl,de
 ld bc,16
 cpir
 JUMP_Z(TBLHexDig)
 cp K_PLUS
 jr z,TBLIncOne
 cp K_MINUS
 jr z,TBLDecOne
 jr TBLMove
TBLLeftCol:
 cp K_DEL
 JUMP_Z(TBLRemLet)
 ld hl,K_Letters
 add hl,de
 ld bc,27
 cpir
 jr nz,TBLMove
 JUMP_(TBLEnterDesc)
TBLMoveUp:
 ld a,(hl)
 or a
 jr z,TBLMove
 CALL_(XorTBLOpt)
 dec (hl)
 jr TBLMoveXor
TBLMoveDown:
 ld a,(hl)
 cp 5
 jr z,TBLMove
TBLXorIt:
 CALL_(XorTBLOpt)
 inc (hl)
 JUMP_(TBLMoveXor)
TBLMoveLeft:
 inc hl
 jr TBLMoveUp
TBLMoveRight:
 inc hl
 ld a,(hl)
 cp 2
 JUMP_Z(TBLMove)
 jr TBLXorIt

TBLClear:
 call z,ClearTable
 JUMP_(TableML)

TBLLetChg:
 ld a,(tmp)
 xor 1
 ld (tmp),a
 JUMP_(TBLMove)

TBLDecOne:
 ld bc,-1
 jr TBLRelChange
TBLIncOne:
 ld bc,1
TBLRelChange:
 ld a,(TBLCurC+1)
 or a
 JUMP_Z(TBLMove)
 push af
 push bc
 CALL_(GetTBLOfs)
 CALL_(XorTBLOpt)
 pop bc
 pop af
 dec a
 jr nz,TBLRelChgMem
 push hl
 call LD_HL_MHL
 add hl,bc
 jr TBLWriteChg
TBLRelChgMem:
 call LD_HL_MHL
 ld a,(hl)
 add a,c
 ld (hl),a
 jr UpdateTable

TBLHexDig:
 ld a,(TBLCurC+1)
 or a
 JUMP_Z(TBLMove)
 push af
 push bc
 CALL_(GetTBLOfs)
 CALL_(XorTBLOpt)
 pop bc
 pop af
 dec a
 jr nz,ChangeMemory
 push hl
 call LD_HL_MHL
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,bc
TBLWriteChg:
 ex de,hl
 pop hl
 ld (hl),e
 inc hl
 ld (hl),d
 ex de,hl
UpdateTable:
 ld a,(TBLCurC)
 add a,a
 add a,a
 add a,a
 add a,$0C
 ld d,a
 ld e,$58
 ld ($8333),de
 push hl
 CALL_(Disp_HL_Hex)
 pop hl
 ld a,$70
 ld ($8333),a
 ld a,(hl)
 CALL_(Disp_A_Hex)
 CALL_(XorTBLOpt)
 JUMP_(TBLMove)
ChangeMemory:
 call LD_HL_MHL
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 add a,a
 add a,c
 ld (hl),a
 jr UpdateTable

XorOpt:
 ld a,(curOpt)
 ld h,a
 ld l,0
 rr h
 rr l
 ld de,$FCC0
 add hl,de
 ld b,7
XorNewRow:
 push bc
 inc hl
 ld b,14
RepXor:
 ld a,$FF
 xor (hl)
 ld (hl),a
 inc hl
 djnz RepXor
 inc hl
 pop bc
 djnz XorNewRow
 ret

ScanMemory:
 ld a,(de)
 cp c
 jr nz,NotEq
 push hl
 ld hl,NrHits
 ld a,(hl)
 cp 32
 jr z,IntScan
 inc (hl)
 pop hl
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
NotEq:
 inc de
 djnz ScanMemory
 ret
IntScan:
 pop hl
 ret

NewSearch:
 xor a
 ld (searches),a

MemorySearch:
 CALL_(ShowHeader)
 ld a,(searches)
 or a
 jr z,EnterVal
 ld b,a
 xor a
 ld hl,$0A03
 ld ($8333),hl
 ld de,searchval
ShowSearches:
 inc a
 push af
 add a,48
 push de
 ROM_CALL(M_CHARPUT)
 ld a,46
 ROM_CALL(M_CHARPUT)
 pop de
 ld hl,$8333
 inc (hl)
 ld a,(de)
 inc de
 CALL_(Disp_A_Hex)
 inc (hl)
 inc (hl)
 inc (hl)
 pop af
 djnz ShowSearches
 ld hl,PossText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$120E
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld a,(nrHits)
 CALL_(Disp_A_Hex)
EnterVal:
 ld hl,SearchText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$3008
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld de,$2425
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 xor a
 ld (tmp),a
EnterHexByte:
 ld hl,$244F
 ld ($8333),hl
 ld a,(tmp)
 ld c,a
 CALL_(Disp_A_Hex)
 CALL_(GetKey)
 jr z,EnterHexByte
 cp K_ENTER
 jr z,Search
 cp K_CLEAR
 JUMP_Z(NewSearch)
 cp $37
 JUMP_Z(ViewMenu)
 ld hl,K_HexCodes
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld bc,16
 cpir
 jr nz,EnterHexByte
 ld hl,tmp
 sla (hl)
 sla (hl)
 sla (hl)
 sla (hl)
 ld a,c
 add a,(hl)
 ld (hl),a
 jr EnterHexByte
Search:
 xor a
 ld (curMemL),a
 ld a,(searches)
 cp 7
 jr z,EnterVal
 or a
 jr nz,CheckPointers
 ld (nrHits),a
 ld hl,pointers
 ld de,$80DF
 ld b,168
 CALL_(ScanMemory)
 ld de,$8A6B
 ld b,168
 CALL_(ScanMemory)
 ld de,$8641
 ld b,0
 CALL_(ScanMemory)
 ld de,$8741
 ld b,0
 CALL_(ScanMemory)
 ld de,$8841
 ld b,0
 CALL_(ScanMemory)
 ld de,$8941
 ld b,0
 CALL_(ScanMemory)
UpdateSearches:
 ld a,(searches)
 ld d,0
 ld e,a
 ld hl,searchval
 add hl,de
 ld a,(tmp)
 ld (hl),a
 ld hl,searches
 inc (hl)
 JUMP_(MemorySearch)
CheckPointers:
 ld a,(nrHits)
 or a
 jr z,UpdateSearches
 ld b,a
 xor a
 ld (nrHits),a
 ld hl,pointers
 ld d,h
 ld e,l
RepCPPointer:
 push hl
 call LD_HL_MHL
 ld a,(hl)
 cp c
 jr nz,CPNotEq
 ex de,hl
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
 ex de,hl
 ld hl,nrHits
 inc (hl)
CPNotEq:
 pop hl
 inc hl
 inc hl
 djnz RepCPPointer
 JUMP_(UpdateSearches)

XORCurMLoc:
 ld de,$FC00
 ld a,(curMemL)
 push af
 and 7
 ld b,a
 add a,a
 add a,a
 add a,a
 sub b
 add a,9
 add a,a
 add a,a
 ld h,0
 ld l,a
 add hl,hl
 add hl,hl
 add hl,de
 pop af
 and %11111000
 srl a
 ld d,0
 ld e,a
 add hl,de
 inc hl
 ld b,7
 ld de,16
RepXorLine:
 push hl
 ld a,$FF
 xor (hl)
 ld (hl),a
 inc hl
 ld a,$FF
 xor (hl)
 ld (hl),a
 inc hl
 ld a,$80
 xor (hl)
 ld (hl),a
 pop hl
 add hl,de
 djnz RepXorLine
 ret

ResultMAS:
 CALL_(ShowHeader)
 ld a,(searches)
 or a
 jr nz,CheckHits
 ld de,$201E
 ld hl,StartFirst
ShowWarningText:
 ld ($8333),de
 ld de,(PROGRAM_ADDR)
 add hl,de
 ROM_CALL(D_ZM_STR)
WK:
 CALL_(GetKey)
 jr z,WK
 JUMP_(ViewMenu)
CheckHits:
 ld a,(nrHits)
 or a
 jr nz,ShowLocations
 ld de,$2004
 ld hl,NoHitsText
 jr ShowWarningText
ShowLocations:
 ld hl,Pointers
 ld b,a
 ld de,$0909
ShowMLoc:
 ld ($8333),de
 push hl
 call LD_HL_MHL
 CALL_(Disp_HL_Hex)
 pop hl
 inc hl
 inc hl
 ld a,7
 add a,d
 ld d,a
 cp 65
 jr nz,ShowNextMLoc
 ld d,$09
 ld a,$20
 add a,e
 ld e,a
ShowNextMLoc:
 djnz ShowMLoc
UpdateCurMLoc:
 CALL_(XORCurMLoc)
MoveCurMLoc:
 CALL_(GetKey)
 jr z,MoveCurMLoc
 cp $37
 JUMP_Z(ViewMenu)
 cp K_ENTER
 JUMP_Z(ViewMenu)
 cp 5
 jr nc,MoveCurMLoc
 push af
 CALL_(XORCurMLoc)
 pop af
 ld hl,curMemL
 ld c,(hl)
 dec a
 jr z,CMLDown
 dec a
 jr z,CMLLeft
 dec a
 jr z,CMLRight
 dec (hl)
CMLCheckB:
 ld b,(hl)
 ld a,(nrHits)
 dec a
 cp b
 jr nc,UpdateCurMLoc
 ld (hl),c
 jr UpdateCurMLoc
CMLDown:
 inc (hl)
 jr CMLCheckB
CMLLeft:
 ld a,8
 sub (hl)
 neg
CMLMoveBack:
 ld (hl),a
 jr CMLCheckB
CMLRight:
 ld a,8
 add a,(hl)
 jr CMLMoveBack

CrashZShell:
 CALL_(ReadKey)
 jr nz,CrashZShell
 call STORE_KEY
 CALL_(RestoreScreen)
 res 2,(iy+12)
 jp $8BFC

ViewScreen:
 CALL_(RestoreScreen)
 CALL_(SaveScreen)
VSWait:
 CALL_(GetKey)
 cp K_SECOND
 jr z,CopyToGraph
 or a
 jr z,VSWait
 JUMP_(ViewMenu)
CopyToGraph:
 ld hl,$FC00
 ld de,$8641
 ld bc,1024
 ldir
 ROM_CALL(CLEARLCD)
 ld hl,$1D12
 ld ($8333),hl
 ld hl,ScreenCopy
 ld de,(PROGRAM_ADDR)
 add hl,de
 ROM_CALL(D_ZM_STR)
VSWaitKey:
 CALL_(GetKey)
 jr z,VSWaitKey
 jr ViewScreen

GameSpeed:
 CALL_(ShowHeader)
ShowSpeed:
 ld hl,$0204
 ld ($800C),hl
 ld hl,CurSpeed
 ld de,(PROGRAM_ADDR)
 add hl,de
 ROM_CALL(D_ZT_STR)
 ld a,(GameDelay)
 add a,48
 ROM_CALL(TX_CHARPUT)
GSWK:
 CALL_(GetKey)
 cp K_EXIT
 JUMP_Z(ViewMenu)
 cp K_ENTER
 JUMP_Z(ViewMenu)
 ld hl,GameDelay
 cp 4
 jr z,SlowDown
 dec a
 jr nz,GSWK
 ld a,(hl)
 or a
 jr z,GSWK
 dec (hl)
 jr ShowSpeed
SlowDown:
 ld a,(hl)
 cp 9
 jr z,GSWK
 inc (hl)
 jr ShowSpeed

SaveGame:
EnterCodes:
 CALL_(ShowHeader)
 ld hl,Sorry
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$1A21
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld de,$2220
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
WaK:
 CALL_(GetKey)
 or a
 jr z,WaK
 jr ViewMenu

ShowMenu:
 CALL_(ShowFrame)
 ld hl,Options1
 ld a,(curMenu)
 or a
 jr z,Menu1
 ld hl,Options2
Menu1:
 ld de,(PROGRAM_ADDR)
 add hl,de
 xor a
ShowOptions:
 push af
 add a,a
 add a,a
 add a,a
 add a,$0C
 ld d,a
 ld e,$0A
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 pop af
 inc a
 cp 4
 jr nz,ShowOptions
 ld hl,$3307
 ld ($8333),hl
 ld hl,MenuBar
 ld de,(PROGRAM_ADDR)
 add hl,de
 ROM_CALL(D_ZM_STR)
 ret

MenuHandler:
 CALL_(GetKey)
 CALL_(SaveScreen)
 jr c,WaitNoKey
 xor a
 ld (curMenu),a
 ld (curOpt),a
ViewMenu:
 CALL_(ShowMenu)
 CALL_(XorOpt)
WaitKey:
 CALL_(GetKey)
 cp K_UP
 jr z,OptUp
 cp K_DOWN
 jr z,OptDown
 cp K_MORE
 jr z,NextMenu
 cp K_ENTER
 jr z,Choose
 cp K_EXIT
 jr nz,WaitKey
 CALL_(RestoreScreen)
WaitNoKey:
 CALL_(ReadKey)
 jr nz,WaitNoKey
 xor a
 call STORE_KEY
 ret

OptUp:
 CALL_(XorOpt)
 ld a,(curOpt)
 dec a
OptChg:
 and 3
 ld (curOpt),a
 CALL_(XorOpt)
 jr WaitKey

OptDown:
 CALL_(XorOpt)
 ld a,(curOpt)
 inc a
 jr OptChg

NextMenu:
 ld a,(curMenu)
 xor 1
 ld (curMenu),a
 xor a
 ld (curOpt),a
 jr ViewMenu

Choose:
 ld a,(curMenu)
 or a
 ld a,(curOpt)
 jr nz,SecondMenu
 or a
 JUMP_Z(MemorySearch)
 dec a
 JUMP_Z(ResultMAS)
 dec a
 JUMP_Z(TableML)
 JUMP_(GameSpeed)

SecondMenu:
 or a
 JUMP_Z(SaveGame)
 dec a
 JUMP_Z(CrashZShell)
 dec a
 JUMP_Z(ViewScreen)
 JUMP_(EnterCodes)

FindStrS:
 .db $0C,4,"gwiz"

StatText:
 .db "Game Wizard",0
 .db "deactivated",0
 .db "Press ON+Enter to pop "
 .db "up the menu",0

Coder:
 .db "by Jimmy Mardell  "
 .db "<mja@algonet.se>",0

Options1:
 .db "Memory Address Search",0
 .db "Result of Memory "
 .db "Address Search",0
 .db "Table of Memory "
 .db "Locations",0
 .db "Game Playing Speed",0

Options2:
 .db "Save Current Program",0
 .db "Crash Back to ZShell",0
 .db "View Current Program "
 .db "Screen",0
 .db "Enter Codes",0

MenuBar:
 .db "[ EXIT - Return | "
 .db "MORE - Next menu ]",0

TBLCoord:
 .db $01,$07,$08,$00
 .db $0A,$03,$02,$80
 .db $0D,$03,$01,$80

K_HexCodes:
 .db K_LN, K_RAISE, K_TAN, K_COS, K_SIN, K_LOG, K_9, K_8, K_7,
 .db K_6, K_5, K_4, K_3, K_2, K_1, K_0

K_Letters:
 .db $11,$19,$21,$0A,$12,$1A,$22,$0B,$13,$1B,$23
 .db $2B,$0C,$14,$1C,$24,$2C,$0D,$15,$1D,$25,$2D
 .db $0E,$16,$1E,$26,$2E

Sorry:
 .db "Sorry, this function ",0
 .db "hasn",39,"t been coded yet",0

PossText:
 .db "Possible memory "
 .db "locations: ",0

SearchText:
 .db "[ CLEAR - New search |"
 .db "EXIT - Back ]",0
 .db "Search for:",0

StartFirst:
 .db "You must search first!",0

NoHitsText:
 .db "No possible memory locations "
 .db "found!",0

ScreenCopy:
 .db "Screen copied to graph mem",0

CurSpeed:
 .db "Current delay: ",0

LCD:
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

#INCLUDE readkey.h

IntStartO:

.org $9292

IntStart:
 ex af,af'
 exx
 ld de,(PROGRAM_ADDR)
 ld (OldPAddr),de
 in a,(3)
 bit 3,a
 jr nz,QExitInt
 ld a,%11111101
 out (1),a
 in a,(1)
 bit 0,a
 jr nz,QExitInt
 ld a,(iy+$0D)
 ld (iy0d),a
 res 1,(iy+$0D)
 ld hl,($800C)
 ld (crs1),hl
 ld hl,($8333)
 ld (crs2),hl
 ld hl,FindStr
 rst 20h
 rst 10h
 jr c,ExitInt
 ld hl,ExitInt
 push hl
 ld hl,5
 add hl,de
 ld (PROGRAM_ADDR),hl
Loop:
 ld a,(hl)
 or a
 jr z,Execute
 inc hl
 jr Loop
Execute:
 inc hl
 inc hl
 inc hl
 jp (hl)

ExitInt:
 ld a,(iy0d)
 ld (iy+$0D),a
 ld hl,(crs1)
 ld ($800C),hl
 ld hl,(crs2)
 ld ($8333),hl
 ld hl,(OldPAddr)
 ld (PROGRAM_ADDR),hl
QExitInt:
 ld a,(gamedelay)
 or a
 jr z,QQExitInt
 ld b,a
RepLoop1:
 ld c,0
RepLoop2:
 dec c
 jr nz,RepLoop2
 djnz RepLoop1
QQExitInt:
 exx
 ex af,af'
 jp $38

ClearTable:
 ld de,MemoryTbl
 ld b,6
RepClrNR:
 push bc
 ld hl,ClearEntry
 ld bc,20
 ldir
 pop bc
 djnz RepClrNR
 ret

ClearEntry:
 .db "----------------",0,0,0,0

IntEnd:

.end
